package com.hc.printer.viewmodel

import android.annotation.SuppressLint
import android.app.DatePickerDialog
import android.app.DatePickerDialog.OnDateSetListener
import android.app.Dialog
import android.app.TimePickerDialog
import android.app.TimePickerDialog.OnTimeSetListener
import android.content.Intent
import android.provider.Settings
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import androidx.databinding.ObservableField
import com.hc.printer.MainActivity
import com.hc.printer.model.Goods
import com.hc.printer.model.MerchantOrder
import com.hc.printer.ui.AddGoodsDialog
import com.hc.printer.ui.DoubleButtonDialog
import com.hc.printer.util.PrinterUtil
import com.hc.printer.util.SimpleTextWatcher
import com.speed.print.Utils
import java.math.BigDecimal
import java.text.DecimalFormat
import java.text.SimpleDateFormat
import java.util.*


/**
 * Created by danbo on 2020/6/29.
 */

class MainViewModel : BaseViewModel() {

    val isPrinterConnected = ObservableField<Boolean>()

    private val orderCalendar = Calendar.getInstance()

    val order = ObservableField<MerchantOrder>().apply {
        set(
            MerchantOrder(
                "",
                "",
                "微信扫码",
                "0025",
                "",
                SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(orderCalendar.time),
                "",
                arrayListOf()
            )
        )
    }

    val merchantName = ObservableField<String>()

    val payType = ObservableField<String>()
    val memberId = ObservableField<String>()
    val orderSn = ObservableField<String>()

    val orderTime = ObservableField<String>().apply {
        set(SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(orderCalendar.time))

        generateSn(null)
    }
    val goods = ObservableField<String>().apply {
        set("")
    }

    val totalPrice = ObservableField<String>()

    override fun getNetworkData() {
        super.getNetworkData()
        (context as MainActivity).apply {
            isPrinterConnected.set(mPrintManager?.isPrintLink)
        }
    }

    //连接打印机c
    fun connect(view: View) {
        context?.let {
            (context as MainActivity).apply {

                if (mPrintManager!!.isPrintLink) {
                    Utils.toast(it, "打印机已连接!")
                    isPrinterConnected.set(true)
                } else {
                    isPrinterConnected.set(false)
                    if (!initPrintManager()) {
                        DoubleButtonDialog(
                            it,
                            null,
                            "未连接打印机",
                            "请先连接打印机后打印",
                            "取消",
                            "去连接",
                            object : DoubleButtonDialog.DialogClickListener {
                                override fun onClick(dialog: Dialog) {
                                    it.startActivity(Intent(Settings.ACTION_BLUETOOTH_SETTINGS))
                                }
                            }
                        ).show()
                    }
                }
            }
        }
    }

    var editWatcher: TextWatcher = object : SimpleTextWatcher() {
        override fun afterTextChanged(s: Editable?) {

            order.get()!!.merchantName = merchantName.get().toString()
        }
    }
    var dateWatcher: TextWatcher = object : SimpleTextWatcher() {
        override fun afterTextChanged(s: Editable?) {

            order.get()!!.orderTime = s.toString()
        }
    }
    var payTypeWatcher: TextWatcher = object : SimpleTextWatcher() {
        override fun afterTextChanged(s: Editable?) {

            order.get()!!.payType = payType.get().toString()
        }
    }
    var snWatcher: TextWatcher = object : SimpleTextWatcher() {
        override fun afterTextChanged(s: Editable?) {

            order.get()!!.orderSn = orderSn.get().toString()
        }
    }

    @SuppressLint("DefaultLocale")
    fun generateSn(view: View?) {
        val sb = StringBuilder()
        val date: String = SimpleDateFormat("yyyyMMdd").format(Date(orderCalendar.timeInMillis))

        val increment: Int = Random().nextInt(99 * 1000)
        sb.append(order.get()!!.id)
        sb.append(date)
        sb.append(java.lang.String.format("%02d", Random().nextInt(99)))
        sb.append(java.lang.String.format("%02d", Random().nextInt(99)))
        val incrementStr = increment.toString()
        if (incrementStr.length <= 6) {
            sb.append(String.format("%06d", increment))
        } else {
            sb.append(incrementStr)
        }
        val sn = sb.toString()

        orderSn.set(sn)
        order.get()!!.orderSn = sn
    }

    @SuppressLint("DefaultLocale")
    fun generateMemberId(view: View?) {

        val increment: Int = Random().nextInt(999)
        val df = DecimalFormat("00000")
        val r = df.format(increment)

        memberId.set(r)
        order.get()!!.memberId = r
    }

    fun pickDate(view: View) {
        // 直接创建一个DatePickerDialog对话框实例，并将它显示出来
        val calendar = Calendar.getInstance()

        DatePickerDialog(context!!, 0,
            OnDateSetListener { _, year, monthOfYear, dayOfMonth ->
                // 绑定监听器(How the parent is notified that the date is set.)
                // 此处得到选择的时间，可以进行你想要的操作
                println("您选择了：" + year + "年" + (monthOfYear + 1) + "月" + dayOfMonth + "日")

                orderCalendar.set(year, monthOfYear, dayOfMonth)

                pickTime()
            } // 设置初始日期
            , calendar.get(Calendar.YEAR)
            , calendar.get(Calendar.MONTH)
            , calendar.get(Calendar.DAY_OF_MONTH)).show()
    }

    private fun pickTime() {
        val calendar = Calendar.getInstance()
        TimePickerDialog(context, 0,  // 绑定监听器
            OnTimeSetListener { _, hourOfDay, minute ->
                println("您选择了：" + hourOfDay + "时" + minute + "分")
                orderCalendar.set(
                    orderCalendar.get(
                        Calendar.YEAR
                    ), orderCalendar.get(
                        Calendar.MONTH
                    ), orderCalendar.get(
                        Calendar.DAY_OF_MONTH
                    ), hourOfDay,
                    minute
                )

                //当前日期
                orderTime.set(SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(orderCalendar.time))

                order.get()!!.orderTime = orderTime.get().toString()
            }
            , calendar.get(Calendar.HOUR_OF_DAY)
            , calendar.get(Calendar.MINUTE) // true表示采用24小时制
            , true).show()
    }

    fun randomTime(view: View) {
        val hourOfDay = Random().nextInt(24)
        val minute = Random().nextInt(59)

        orderCalendar.set(
            orderCalendar.get(
                Calendar.YEAR
            ), orderCalendar.get(
                Calendar.MONTH
            ), orderCalendar.get(
                Calendar.DAY_OF_MONTH
            ), hourOfDay,
            minute
        )

        //当前日期
        orderTime.set(SimpleDateFormat("yyyy-MM-dd HH:mm").format(orderCalendar.time))
    }

    fun addGoods(view: View) {
        AddGoodsDialog(context!!, object : AddGoodsDialog.DialogClickListener {
            override fun onClick(name: String, quantity: Int, price: BigDecimal) {
                //
                order.get()?.let {
                    val goods = Goods(it.goodsList.size + 1, name, quantity, price)
                    it.goodsList.add(goods)

                    var gs = ""
                    var tp = BigDecimal.ZERO
                    for (g in it.goodsList) {
                        gs =
                            gs + "\n" + g.id + "   " + g.name + "   " + g.quantity + "   " + g.price

                        tp = tp.plus(g.price.multiply(g.quantity.toBigDecimal()))
                    }

                    totalPrice.set(tp.toPlainString())

                    it.totalPrice = totalPrice.get()!!

                    this@MainViewModel.goods.set(gs)

                    println("---${gs}---${this@MainViewModel.goods.get()}")
                }

            }

        }).show()
    }

    fun clearGoods(view: View) {
        totalPrice.set("")

        order.get()?.let {
            it.totalPrice = totalPrice.get()!!
            it.goodsList.clear()

            this@MainViewModel.goods.set("")
        }

    }

    fun print(view: View) {
        order.get()?.let {
            PrinterUtil.print(context!!, it)
        }
    }
}