package com.hc.printer.viewmodel


import android.content.Context
import android.content.Intent
import android.text.TextUtils
import androidx.lifecycle.ViewModel
import com.hc.printer.ui.BaseActivity
import java.io.Serializable

/**
 * Created by danbo on 2019-11-07.
 */
open class BaseViewModel : ViewModel() {
    var context: Context? = null

    open fun getNetworkData() {}

    open fun startActivity(cls: Class<*>) {
        startActivity(cls, null, null)
    }

    open fun startActivity(cls: Class<*>, key: String?, value: Any?) {
        context?.let {
            val intent = Intent(it, cls)
            if (value is String && !TextUtils.isEmpty(value) && !TextUtils.isEmpty(key)) {
                intent.putExtra(key, value)
            } else if (!TextUtils.isEmpty(key) && value != null && value is Serializable) {
                intent.putExtra(key, value)
            }
            it.startActivity(intent)
        }

    }


    open fun getIntent(): Intent {
        return (context as BaseActivity<*>).intent
    }

    open fun finish() {
        (context as BaseActivity<*>).finish()
    }

}