package com.hc.printer.ui

import android.app.Dialog
import android.content.Context
import android.view.View
import com.hc.printer.R
import kotlinx.android.synthetic.main.layout_double_dialog.*

/**
 * Created by danbo on 2019/11/13.
 *
 * 两个按钮的对话框
 */
class DoubleButtonDialog(
    context: Context,
    private val logo: Int?,
    private val title: String?,
    private val info: String,
    private val cancelText: String,
    private val okText: String,
    private var listener: DialogClickListener?
) : BaseDialog(context), View.OnClickListener {

    override val layoutId: Int
        get() = R.layout.layout_double_dialog


    public override fun initView() {
        btn_ok!!.setOnClickListener(this)
        btn_cancel.setOnClickListener(this)

        logo?.let {
            iv_info.setImageResource(logo)
        }
        title?.let {
            tv_title.text = title
        }

        tv_info.text = info

        btn_cancel.text = cancelText
        btn_ok.text = okText
    }

    override fun onClick(view: View) {
        dismiss()
        if (listener != null) {
            when (view.id) {
                R.id.btn_cancel -> {
                    listener?.onCancel(this)
                }
                R.id.btn_ok -> {
                    listener?.onClick(this)
                }
            }

        }
    }

    interface DialogClickListener {
        fun onClick(dialog: Dialog)
        fun onCancel(dialog: Dialog){}
    }

}
