package com.hc.printer.ui

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import com.hc.printer.R

/**
 * Created by danbo on 2019-11-13.
 */
abstract class BaseDialog(context: Context) : Dialog(context,  R.style.CommonDialog) {

    abstract val layoutId: Int

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(layoutId)
        //点击外部的话不让popuWindow消失
        setCanceledOnTouchOutside(false)
        initView()
    }

    protected abstract fun initView()
}
