package com.hc.printer.ui

import android.app.Dialog
import android.content.Context
import android.view.View
import com.hc.printer.R
import kotlinx.android.synthetic.main.layout_add_goods_dialog.*
import java.math.BigDecimal

/**
 * Created by danbo on 2019/11/13.
 *
 */
class AddGoodsDialog(
    context: Context,
    private var listener: DialogClickListener?
) : BaseDialog(context), View.OnClickListener {

    override val layoutId: Int
        get() = R.layout.layout_add_goods_dialog


    public override fun initView() {
        btn_ok!!.setOnClickListener(this)
        btn_cancel.setOnClickListener(this)
    }

    override fun onClick(view: View) {
        if (view.id == R.id.btn_ok) {
            if (name.text.isNullOrEmpty() || quantity.text.isNullOrEmpty() || price.text.isNullOrEmpty()) {
                return
            }
        }

        dismiss()
        if (listener != null) {
            when (view.id) {
                R.id.btn_cancel -> {
                    listener?.onCancel(this)
                }
                R.id.btn_ok -> {
                    listener?.onClick(
                        name.text.toString(),
                        quantity.text.toString().toInt(),
                        price.text.toString().toBigDecimal()
                    )
                }
            }

        }
    }

    interface DialogClickListener {
        fun onClick(name: String, quantity: Int, price: BigDecimal)
        fun onCancel(dialog: Dialog) {}
    }

}
