/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.util.Log;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.Vector;

public class SerialPortFinder {
    private static final String TAG = SerialPortFinder.class.getSimpleName();
    private Vector<Driver> mDrivers = null;

    Vector<Driver> getDrivers() throws IOException {
        if (this.mDrivers == null) {
            String l;
            this.mDrivers = new Vector();
            LineNumberReader r = new LineNumberReader(new FileReader("/proc/tty/drivers"));
            while ((l = r.readLine()) != null) {
                String drivername = l.substring(0, 21).trim();
                String[] w = l.split(" +");
                if (w.length < 5 || !w[w.length - 1].equals("serial")) continue;
                Log.d((String)TAG, (String)("???? Found new driver " + drivername + " on " + w[w.length - 4]));
                this.mDrivers.add(new Driver(drivername, w[w.length - 4]));
            }
            r.close();
        }
        return this.mDrivers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAllDevices() {
        Vector<String> devices = new Vector<String>();
        try {
            Iterator<Driver> itdriv = this.getDrivers().iterator();
            block2: while (true) {
                if (!itdriv.hasNext()) {
                    return devices.toArray(new String[devices.size()]);
                }
                Driver driver = itdriv.next();
                Vector<File> files = driver.getDevices();
                if (files == null) {
                    return null;
                }
                Iterator<File> iterator = files.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    File file = iterator.next();
                    String device = file.getName();
                    String value = String.format("%s (%s)", device, driver.getName());
                    devices.add(value);
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAllDevicesPath() {
        Vector<String> devices = new Vector<String>();
        try {
            Iterator<Driver> itdriv = this.getDrivers().iterator();
            block2: while (true) {
                if (!itdriv.hasNext()) {
                    return devices.toArray(new String[devices.size()]);
                }
                Driver driver = itdriv.next();
                Vector<File> files = driver.getDevices();
                if (files == null) {
                    return null;
                }
                Iterator<File> iterator = files.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    File file = iterator.next();
                    String device = file.getAbsolutePath();
                    devices.add(device);
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    public class Driver {
        private String mDriverName;
        private String mDeviceRoot;
        Vector<File> mDevices = null;

        public Driver(String name, String root) {
            this.mDriverName = name;
            this.mDeviceRoot = root;
        }

        public Vector<File> getDevices() {
            if (this.mDevices == null) {
                this.mDevices = new Vector();
                File dev = new File("/dev");
                File[] files = dev.listFiles();
                if (files == null) {
                    return null;
                }
                int i = 0;
                while (i < files.length) {
                    if (files[i].getAbsolutePath().startsWith(this.mDeviceRoot)) {
                        Log.d((String)TAG, (String)("???? Found new device: " + files[i]));
                        this.mDevices.add(files[i]);
                    }
                    ++i;
                }
            }
            return this.mDevices;
        }

        public String getName() {
            return this.mDriverName;
        }
    }
}

