/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrinterTool {
    public static byte[] convertVectorByteToBytes(Vector<Byte> data) {
        byte[] sendData = new byte[data.size()];
        if (data.size() > 0) {
            int i = 0;
            while (i < data.size()) {
                sendData[i] = data.get(i);
                ++i;
            }
        }
        return sendData;
    }

    public static List<byte[]> getListByteArray(byte[] bytes, int counts) {
        ArrayList<byte[]> lists = new ArrayList<byte[]>();
        int f = bytes.length / counts;
        int length = 0;
        int i = 0;
        while (i < f) {
            byte[] bbb = new byte[counts];
            int j = 0;
            while (j < counts) {
                bbb[j] = bytes[j + i * counts];
                ++j;
            }
            length += bbb.length;
            lists.add(bbb);
            ++i;
        }
        if (length < bytes.length) {
            byte[] a = new byte[bytes.length - length];
            int i2 = 0;
            while (i2 < bytes.length - length) {
                a[i2] = bytes[length + i2];
                ++i2;
            }
            lists.add(a);
        }
        return lists;
    }

    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }

    public static boolean checkPairCode(String pairCode) {
        return pairCode.matches("^\\d{4}$");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIP(String addr) {
        if (addr.length() < 7) return false;
        if (addr.length() > 15) return false;
        if ("".equals(addr)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        if (!ipAddress) return ipAddress;
        String[] ips = addr.split("\\.");
        if (ips.length != 4) return false;
        try {
            String[] stringArray = ips;
            int n = ips.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String ip = stringArray[n2];
                if (Integer.parseInt(ip) < 0) return false;
                if (Integer.parseInt(ip) > 255) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }
}

