/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.gprinter.io.PortManager;
import com.gprinter.utils.PrinterTool;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class UsbPort
extends PortManager {
    private static final int TRANSFER_TIMEOUT = 1000;
    private static final int SPLITE_SIZE = 64;
    private static final String TAG = UsbPort.class.getSimpleName();
    private final Object mLock = new Object();
    private boolean isConn = false;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private UsbDevice usbDevice;
    private UsbManager usbManager;
    private Context mContext;
    private UsbDeviceConnection mmConnection;
    private UsbInterface mmIntf;
    private UsbEndpoint mmEndIn;
    private UsbEndpoint mmEndOut;
    private PendingIntent mPermissionIntent;

    public UsbPort(Context context, UsbDevice usbDevice) {
        this.mContext = context;
        this.usbDevice = usbDevice;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    private UsbPort() {
    }

    public void setUsbDevice(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    @Override
    public boolean openPort() {
        if (this.usbDevice != null) {
            if (!this.usbManager.hasPermission(this.usbDevice)) {
                Log.e((String)TAG, (String)"USB is not permission");
                this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
                this.usbManager.requestPermission(this.usbDevice, this.mPermissionIntent);
            } else if (this.checkUsbDevicePidVid(this.usbDevice)) {
                this.openUsbPort();
                if (this.mmEndOut != null && this.mmEndIn != null) {
                    this.isConn = true;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    private void openUsbPort() {
        UsbInterface usbInterface;
        int count = this.usbDevice.getInterfaceCount();
        UsbInterface intf = null;
        int i = 0;
        if (i >= count || (intf = (usbInterface = this.usbDevice.getInterface(i))).getInterfaceClass() == 7) {
            // empty if block
        }
        if (intf != null) {
            this.mmIntf = intf;
            this.mmConnection = null;
            this.mmConnection = this.usbManager.openDevice(this.usbDevice);
            if (this.mmConnection != null && this.mmConnection.claimInterface(intf, true)) {
                i = 0;
                while (i < intf.getEndpointCount()) {
                    UsbEndpoint ep = intf.getEndpoint(i);
                    if (ep.getType() == 2) {
                        if (ep.getDirection() == 0) {
                            this.mmEndOut = ep;
                        } else {
                            this.mmEndIn = ep;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void writeDataImmediately(Vector<Byte> sendData, int off, int len) throws IOException {
        int offset = 0;
        byte[] data = PrinterTool.convertVectorByteToBytes(sendData);
        List<byte[]> mlist = PrinterTool.getListByteArray(data, 64);
        int packNum = 0;
        while (packNum < mlist.size()) {
            int ret = this.mmConnection.bulkTransfer(this.mmEndOut, mlist.get(packNum), mlist.get(packNum).length, 1000);
            Log.e((String)TAG, (String)("send result" + ret));
            if (ret > 0) {
                offset += ret;
                ++packNum;
            } else {
                Log.e((String)TAG, (String)"send error");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.isConn) continue;
            Log.e((String)TAG, (String)"Interrupt transmission");
            break;
        }
        if (offset == data.length) {
            Log.e((String)TAG, (String)"send success");
        }
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        if (this.mmConnection != null) {
            return this.mmConnection.bulkTransfer(this.mmEndIn, bytes, bytes.length, 2000);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closePort() {
        Object object = this.mLock;
        synchronized (object) {
            block5: {
                if (this.mmIntf == null || this.mmConnection == null) break block5;
                this.mmConnection.releaseInterface(this.mmIntf);
                this.mmConnection.close();
                this.mmConnection = null;
                if (this.usbManager != null) {
                    this.usbManager = null;
                }
                this.isConn = false;
                return true;
            }
        }
        return false;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    private boolean checkUsbDevicePidVid(UsbDevice dev) {
        int pid = dev.getProductId();
        int vid = dev.getVendorId();
        boolean rel = true;
        if (vid == 34918 && pid == 256 || vid == 1137 && pid == 85 || vid == 6790 && pid == 30084 || vid == 26728 && pid == 256 || vid == 26728 && pid == 512 || vid == 26728 && pid == 256 || vid == 26728 && pid == 768 || vid == 26728 && pid == 1024 || vid == 26728 && pid == 1280 || vid == 26728 && pid == 1536 || vid == 7358 && pid == 2) {
            rel = true;
        }
        return rel;
    }
}

