/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.util.Log;
import com.gprinter.io.PortManager;
import com.gprinter.utils.SerialPortControl;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class SerialPort
extends PortManager {
    private static final String TAG = "SerialPort";
    private int baudrate;
    private String serialPortPath;
    private int flags;
    private SerialPortControl serialPortControl;

    public SerialPort(String path, int baudrate, int flags) {
        this.serialPortPath = path;
        this.baudrate = baudrate;
        this.flags = flags;
    }

    public SerialPort() {
    }

    public void setSerialPortPath(String path) {
        this.serialPortPath = path;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    public void setFlage(int flags) {
        this.flags = flags;
    }

    @Override
    public boolean openPort() {
        try {
            File file = new File(this.serialPortPath);
            if (file.exists()) {
                this.serialPortControl = new SerialPortControl(file, this.baudrate, this.flags);
                this.inputStream = this.serialPortControl.getInputStream();
                this.outputStream = this.serialPortControl.getOutputStream();
                if (this.inputStream != null && this.outputStream != null) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Open serial port error!", (Throwable)e);
        }
        return false;
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        try {
            if (data.size() > 0) {
                this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"write data error!", (Throwable)e);
        }
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        if (this.inputStream.available() > 0) {
            return this.inputStream.read(bytes);
        }
        return 0;
    }

    @Override
    public boolean closePort() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.serialPortControl != null) {
                this.serialPortControl.close();
                this.serialPortControl = null;
            }
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close the steam or serial port error!", (Throwable)e);
            return false;
        }
    }
}

