/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.util.Log;
import com.gprinter.io.PortManager;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class EthernetPort
extends PortManager {
    private static final String TAG = EthernetPort.class.getSimpleName();
    private Socket mSocket;
    private InetAddress mInetAddress;
    private String mIp;
    private int mPort;
    private SocketAddress mSocketAddress;
    private boolean connSuccessful;
    private boolean connState;

    public EthernetPort(String ip, int port) {
        this.mIp = ip;
        this.mPort = port;
    }

    public EthernetPort() {
    }

    public void setIp(String ip) {
        this.mIp = ip;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    private void initSocketStream() throws IOException {
        this.inputStream = this.mSocket.getInputStream();
        this.outputStream = this.mSocket.getOutputStream();
    }

    @Override
    public boolean openPort() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                EthernetPort.this.mSocket = new Socket();
                try {
                    EthernetPort.this.mInetAddress = Inet4Address.getByName(EthernetPort.this.mIp);
                    EthernetPort.this.mSocketAddress = new InetSocketAddress(EthernetPort.this.mInetAddress, EthernetPort.this.mPort);
                    EthernetPort.this.mSocket.connect(EthernetPort.this.mSocketAddress, 4000);
                    EthernetPort.this.initSocketStream();
                    EthernetPort.this.connSuccessful = true;
                }
                catch (UnknownHostException e) {
                    Log.e((String)TAG, (String)"IpAddress is invalid", (Throwable)e);
                    EthernetPort.this.connSuccessful = false;
                }
                catch (IOException e) {
                    EthernetPort.this.connSuccessful = false;
                    Log.e((String)TAG, (String)"connect failed", (Throwable)e);
                    try {
                        if (EthernetPort.this.mSocket != null) {
                            EthernetPort.this.mSocket.close();
                        }
                    }
                    catch (IOException e1) {
                        Log.e((String)TAG, (String)"unable to close() socket during connection failure", (Throwable)e1);
                    }
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.connSuccessful;
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        try {
            if (this.mSocket != null && this.outputStream != null && data.size() > 0) {
                this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"EthernetPort.class writeDataImmediately method error!", (Throwable)e);
            throw e;
        }
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        int len = 0;
        try {
            len = this.inputStream.read(bytes);
            Log.e((String)TAG, (String)("read length" + len));
            return len;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"connection device is lost");
            throw e;
        }
    }

    @Override
    public boolean closePort() {
        try {
            this.closeStreamAndSocket();
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close port error!", (Throwable)e);
            return false;
        }
    }

    private void closeStreamAndSocket() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.mSocket != null) {
            this.mSocket.close();
            this.mSocket = null;
        }
    }
}

