/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.util.Log;
import com.gprinter.io.PortManager;
import java.io.IOException;
import java.util.UUID;
import java.util.Vector;

public class BluetoothPort
extends PortManager {
    private static final String TAG = BluetoothPort.class.getSimpleName();
    private static final UUID SERIAL_PORT_SERVICE_CLASS_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static final String NAME = "BluetoothPort";
    private BluetoothAdapter mAdapter = null;
    private BluetoothDevice device;
    private BluetoothSocket mSocket;
    private int state = 0;
    private String macAddress;

    private void initSocketStream() throws IOException {
        this.inputStream = this.mSocket.getInputStream();
        this.outputStream = this.mSocket.getOutputStream();
    }

    @Override
    public boolean openPort() {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAdapter.cancelDiscovery();
        if (this.mAdapter == null) {
            this.state = 0;
            Log.e((String)TAG, (String)"Bluetooth is not support");
        } else if (!this.mAdapter.isEnabled()) {
            this.state = 0;
            Log.e((String)TAG, (String)"Bluetooth is not open");
        } else {
            block7: {
                if (!BluetoothAdapter.checkBluetoothAddress((String)this.macAddress)) break block7;
                this.device = this.mAdapter.getRemoteDevice(this.macAddress);
                this.mSocket = this.device.createInsecureRfcommSocketToServiceRecord(SERIAL_PORT_SERVICE_CLASS_UUID);
                this.mSocket.connect();
                this.initSocketStream();
                this.state = 3;
                return true;
            }
            try {
                this.state = 0;
                Log.e((String)TAG, (String)"Bluetooth address is invalid");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.macAddress = "";
        return false;
    }

    public BluetoothPort(String macAddress) {
        this.macAddress = macAddress;
    }

    public void writeData(byte[] data) {
        if (this.mSocket != null && this.outputStream != null && data != null && data.length > 0) {
            try {
                this.outputStream.write(data, 0, data.length);
                this.outputStream.flush();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception occured while sending data immediately: ", (Throwable)e);
            }
        }
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        if (this.mSocket != null && this.outputStream != null && data != null && data.size() > 0) {
            try {
                this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                this.outputStream.flush();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception occured while sending data immediately: ", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public int readData(byte[] bytes) throws IOException {
        if (this.mSocket == null) {
            throw new IOException();
        }
        int len = 0;
        try {
            len = this.inputStream.read(bytes);
            Log.e((String)TAG, (String)("read length" + len));
            return len;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"connection device is lost");
            throw e;
        }
    }

    @Override
    public boolean closePort() {
        try {
            this.closeConn();
            this.state = 0;
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close port error! ", (Throwable)e);
            return false;
        }
    }

    private void closeConn() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.mSocket != null) {
            this.mSocket.close();
            this.mSocket = null;
        }
    }
}

