/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Environment;
import com.gprinter.command.LabelCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GpUtils {
    private static Pattern pattern = Pattern.compile("([a-zA-Z0-9!@#$^&*\\(\\)~\\{\\}:\",\\.<>/]+)");
    private static int[] p0;
    private static int[] p1;
    private static int[] p2;
    private static int[] p3;
    private static int[] p4;
    private static int[] p5;
    private static int[] p6;
    private static int[][] Floyd16x16;
    private static int[][] Floyd8x8;
    public static final int PAPER_58_WIDTH = 32;
    public static final int PAPER_80_WIDTH = 48;
    private static int sPaperWidth;
    private static Integer[] theSet0;
    private static Integer[][] FormatTable;
    static Integer[] theSet1;
    static Integer[] theSet2;
    public static final int ALGORITHM_DITHER_16x16 = 16;
    public static final int ALGORITHM_DITHER_8x8 = 8;
    public static final int ALGORITHM_TEXTMODE = 2;
    public static final int ALGORITHM_GRAYTEXTMODE = 1;
    public static final int[][] COLOR_PALETTE;
    private static int method;
    public static final int FLOYD_STEINBERG_DITHER = 1;
    public static final int ATKINSON_DITHER = 2;

    static {
        int[] nArray = new int[2];
        nArray[1] = 128;
        p0 = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 64;
        p1 = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 32;
        p2 = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 16;
        p3 = nArray4;
        int[] nArray5 = new int[2];
        nArray5[1] = 8;
        p4 = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 4;
        p5 = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = 2;
        p6 = nArray7;
        int[][] nArrayArray = new int[16][];
        int[] nArray8 = new int[16];
        nArray8[1] = 128;
        nArray8[2] = 32;
        nArray8[3] = 160;
        nArray8[4] = 8;
        nArray8[5] = 136;
        nArray8[6] = 40;
        nArray8[7] = 168;
        nArray8[8] = 2;
        nArray8[9] = 130;
        nArray8[10] = 34;
        nArray8[11] = 162;
        nArray8[12] = 10;
        nArray8[13] = 138;
        nArray8[14] = 42;
        nArray8[15] = 170;
        nArrayArray[0] = nArray8;
        nArrayArray[1] = new int[]{192, 64, 224, 96, 200, 72, 232, 104, 194, 66, 226, 98, 202, 74, 234, 106};
        nArrayArray[2] = new int[]{48, 176, 16, 144, 56, 184, 24, 152, 50, 178, 18, 146, 58, 186, 26, 154};
        nArrayArray[3] = new int[]{240, 112, 208, 80, 248, 120, 216, 88, 242, 114, 210, 82, 250, 122, 218, 90};
        nArrayArray[4] = new int[]{12, 140, 44, 172, 4, 132, 36, 164, 14, 142, 46, 174, 6, 134, 38, 166};
        nArrayArray[5] = new int[]{204, 76, 236, 108, 196, 68, 228, 100, 206, 78, 238, 110, 198, 70, 230, 102};
        nArrayArray[6] = new int[]{60, 188, 28, 156, 52, 180, 20, 148, 62, 190, 30, 158, 54, 182, 22, 150};
        nArrayArray[7] = new int[]{252, 124, 220, 92, 244, 116, 212, 84, 254, 126, 222, 94, 246, 118, 214, 86};
        nArrayArray[8] = new int[]{3, 131, 35, 163, 11, 139, 43, 171, 1, 129, 33, 161, 9, 137, 41, 169};
        nArrayArray[9] = new int[]{195, 67, 227, 99, 203, 75, 235, 107, 193, 65, 225, 97, 201, 73, 233, 105};
        nArrayArray[10] = new int[]{51, 179, 19, 147, 59, 187, 27, 155, 49, 177, 17, 145, 57, 185, 25, 153};
        nArrayArray[11] = new int[]{243, 115, 211, 83, 251, 123, 219, 91, 241, 113, 209, 81, 249, 121, 217, 89};
        nArrayArray[12] = new int[]{15, 143, 47, 175, 7, 135, 39, 167, 13, 141, 45, 173, 5, 133, 37, 165};
        nArrayArray[13] = new int[]{207, 79, 239, 111, 199, 71, 231, 103, 205, 77, 237, 109, 197, 69, 229, 101};
        nArrayArray[14] = new int[]{63, 191, 31, 159, 55, 183, 23, 151, 61, 189, 29, 157, 53, 181, 21, 149};
        nArrayArray[15] = new int[]{254, 127, 223, 95, 247, 119, 215, 87, 253, 125, 221, 93, 245, 117, 213, 85};
        Floyd16x16 = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        int[] nArray9 = new int[8];
        nArray9[1] = 32;
        nArray9[2] = 8;
        nArray9[3] = 40;
        nArray9[4] = 2;
        nArray9[5] = 34;
        nArray9[6] = 10;
        nArray9[7] = 42;
        nArrayArray2[0] = nArray9;
        nArrayArray2[1] = new int[]{48, 16, 56, 24, 50, 18, 58, 26};
        nArrayArray2[2] = new int[]{12, 44, 4, 36, 14, 46, 6, 38};
        nArrayArray2[3] = new int[]{60, 28, 52, 20, 62, 30, 54, 22};
        nArrayArray2[4] = new int[]{3, 35, 11, 43, 1, 33, 9, 41};
        nArrayArray2[5] = new int[]{51, 19, 59, 27, 49, 17, 57, 25};
        nArrayArray2[6] = new int[]{15, 47, 7, 39, 13, 45, 5, 37};
        nArrayArray2[7] = new int[]{63, 31, 55, 23, 61, 29, 53, 21};
        Floyd8x8 = nArrayArray2;
        sPaperWidth = 48;
        theSet0 = new Integer[]{1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 17442, 17443, 17445, 17447};
        FormatTable = new Integer[][]{{65152, 65152, 65152, 65152}, {65153, 65154, 65153, 65154}, {65155, 65156, 65155, 65156}, {65157, 65157, 65157, 65157}, {65149, 65149, 65149, 65149}, {65163, 65163, 65163, 65163}, {65165, 65166, 65165, 65166}, {65167, 65167, 65169, 65169}, {65171, 65171, 65171, 65171}, {65173, 65173, 65175, 65175}, {65177, 65177, 65179, 65179}, {65181, 65181, 65183, 65183}, {65185, 65185, 65187, 65187}, {65189, 65189, 65191, 65191}, {65193, 65193, 65193, 65193}, {65195, 65195, 65195, 65195}, {65197, 65197, 65197, 65197}, {65199, 65199, 65199, 65199}, {65201, 65201, 65203, 65203}, {65205, 65205, 65207, 65207}, {65209, 65209, 65211, 65211}, {65213, 65213, 65215, 65215}, {65217, 65217, 65217, 65217}, {65221, 65221, 65221, 65221}, {65225, 65226, 65227, 65228}, {65229, 65230, 65231, 65232}, {65233, 65233, 65235, 65235}, {65237, 65237, 65239, 65239}, {65241, 65241, 65243, 65243}, {65245, 65245, 65247, 65247}, {65249, 65249, 65251, 65251}, {65253, 65253, 65255, 65255}, {65257, 65257, 65259, 65259}, {65261, 65261, 65261, 65261}, {65263, 65264, 65263, 65264}, {65265, 65266, 65267, 65267}, {65269, 65270, 65269, 65270}, {65271, 65272, 65271, 65272}, {65273, 65274, 65273, 65274}, {65275, 65276, 65275, 65276}};
        theSet1 = new Integer[]{1574, 1576, 1578, 1579, 1580, 1581, 1582, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1610};
        theSet2 = new Integer[]{1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610};
        COLOR_PALETTE = new int[][]{new int[3], {255, 255, 255}};
        method = 1;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        Bitmap BitmapOrg = bitmap;
        int width = BitmapOrg.getWidth();
        int height = BitmapOrg.getHeight();
        int newWidth = w;
        int newHeight = h;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)BitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static void saveMyBitmap(Bitmap mBitmap) {
        File f = new File(Environment.getExternalStorageDirectory().getPath(), "Btatotest.jpeg");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(f);
            mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    static byte[] pixToEscRastBitImageCmd(byte[] src, int nWidth, int nMode) {
        int nHeight = src.length / nWidth;
        byte[] data = new byte[8 + src.length / 8];
        data[0] = 29;
        data[1] = 118;
        data[2] = 48;
        data[3] = (byte)(nMode & 1);
        data[4] = (byte)(nWidth / 8 % 256);
        data[5] = (byte)(nWidth / 8 / 256);
        data[6] = (byte)(nHeight % 256);
        data[7] = (byte)(nHeight / 256);
        int i = 8;
        int k = 0;
        while (i < data.length) {
            data[i] = (byte)(p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
            k += 8;
            ++i;
        }
        return data;
    }

    public static byte[] pixToEscRastBitImageCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int i = 0;
        int k = 0;
        while (i < data.length) {
            data[i] = (byte)(p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
            k += 8;
            ++i;
        }
        return data;
    }

    static byte[] pixToEscNvBitImageCmd(byte[] src, int width, int height) {
        byte[] data = new byte[src.length / 8 + 4];
        data[0] = (byte)(width / 8 % 256);
        data[1] = (byte)(width / 8 / 256);
        data[2] = (byte)(height / 8 % 256);
        data[3] = (byte)(height / 8 / 256);
        int k = 0;
        int i = 0;
        while (i < width) {
            k = 0;
            int j = 0;
            while (j < height / 8) {
                data[4 + j + i * height / 8] = (byte)(p0[src[i + k]] + p1[src[i + k + 1 * width]] + p2[src[i + k + 2 * width]] + p3[src[i + k + 3 * width]] + p4[src[i + k + 4 * width]] + p5[src[i + k + 5 * width]] + p6[src[i + k + 6 * width]] + src[i + k + 7 * width]);
                k += 8 * width;
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static byte[] pixToLabelCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int k = 0;
        int j = 0;
        while (k < data.length) {
            byte temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            data[k] = ~temp;
            j += 8;
            ++k;
        }
        return data;
    }

    public static byte[] pixToTscCmd(int x, int y, int mode, byte[] src, int nWidth) {
        int height = src.length / nWidth;
        int width = nWidth / 8;
        String str = "BITMAP " + x + "," + y + "," + width + "," + height + "," + mode + ",";
        byte[] bitmap = null;
        try {
            bitmap = str.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] arrayOfByte = new byte[src.length / 8];
        int k = 0;
        int j = 0;
        while (k < arrayOfByte.length) {
            byte temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            arrayOfByte[k] = ~temp;
            j += 8;
            ++k;
        }
        byte[] data = new byte[bitmap.length + arrayOfByte.length];
        System.arraycopy(bitmap, 0, data, 0, bitmap.length);
        System.arraycopy(arrayOfByte, 0, data, bitmap.length, arrayOfByte.length);
        return data;
    }

    private static void format_K_dither16x16(int[] orgpixels, int xsize, int ysize, byte[] despixels) {
        int k = 0;
        int y = 0;
        while (y < ysize) {
            int x = 0;
            while (x < xsize) {
                despixels[k] = (orgpixels[k] & 0xFF) > Floyd16x16[x & 0xF][y & 0xF] ? (byte)0 : 1;
                ++k;
                ++x;
            }
            ++y;
        }
    }

    public static byte[] bitmapToBWPix(Bitmap mBitmap) {
        int[] pixels = new int[mBitmap.getWidth() * mBitmap.getHeight()];
        byte[] data = new byte[mBitmap.getWidth() * mBitmap.getHeight()];
        Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
        grayBitmap.getPixels(pixels, 0, mBitmap.getWidth(), 0, 0, mBitmap.getWidth(), mBitmap.getHeight());
        GpUtils.format_K_dither16x16(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), data);
        return data;
    }

    private static void format_K_dither16x16_int(int[] orgpixels, int xsize, int ysize, int[] despixels) {
        int k = 0;
        int y = 0;
        while (y < ysize) {
            int x = 0;
            while (x < xsize) {
                despixels[k] = (orgpixels[k] & 0xFF) > Floyd16x16[x & 0xF][y & 0xF] ? -1 : -16777216;
                ++k;
                ++x;
            }
            ++y;
        }
    }

    private static void format_K_dither8x8_int(int[] orgpixels, int xsize, int ysize, int[] despixels) {
        int k = 0;
        int y = 0;
        while (y < ysize) {
            int x = 0;
            while (x < xsize) {
                despixels[k] = (orgpixels[k] & 0xFF) >> 2 > Floyd8x8[x & 7][y & 7] ? -1 : -16777216;
                ++k;
                ++x;
            }
            ++y;
        }
    }

    public static int[] bitmapToBWPix_int(Bitmap mBitmap, int algorithm) {
        int[] pixels = new int[]{};
        switch (algorithm) {
            case 8: {
                Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
                pixels = new int[grayBitmap.getWidth() * grayBitmap.getHeight()];
                grayBitmap.getPixels(pixels, 0, grayBitmap.getWidth(), 0, 0, grayBitmap.getWidth(), grayBitmap.getHeight());
                GpUtils.format_K_dither8x8_int(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), pixels);
                break;
            }
            case 2: {
                break;
            }
            default: {
                Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
                pixels = new int[grayBitmap.getWidth() * grayBitmap.getHeight()];
                grayBitmap.getPixels(pixels, 0, grayBitmap.getWidth(), 0, 0, grayBitmap.getWidth(), grayBitmap.getHeight());
                GpUtils.format_K_dither16x16_int(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), pixels);
            }
        }
        return pixels;
    }

    public static Bitmap toBinaryImage(Bitmap mBitmap, int nWidth, int algorithm) {
        int width = (nWidth + 7) / 8 * 8;
        int height = mBitmap.getHeight() * width / mBitmap.getWidth();
        Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
        int[] pixels = GpUtils.bitmapToBWPix_int(rszBitmap, algorithm);
        rszBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return rszBitmap;
    }

    private static int getCloseColor(int tr, int tg, int tb) {
        int minDistanceSquared = 195076;
        int bestIndex = 0;
        int i = 0;
        while (i < COLOR_PALETTE.length) {
            int rdiff = tr - COLOR_PALETTE[i][0];
            int gdiff = tg - COLOR_PALETTE[i][1];
            int bdiff = tb - COLOR_PALETTE[i][2];
            int distanceSquared = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff;
            if (distanceSquared < minDistanceSquared) {
                minDistanceSquared = distanceSquared;
                bestIndex = i;
            }
            ++i;
        }
        return bestIndex;
    }

    private static void setPixel(int[] input, int width, int height, int col, int row, int[] p) {
        if (col < 0 || col >= width) {
            col = 0;
        }
        if (row < 0 || row >= height) {
            row = 0;
        }
        int index = row * width + col;
        input[index] = 0xFF000000 | GpUtils.clamp(p[0]) << 16 | GpUtils.clamp(p[1]) << 8 | GpUtils.clamp(p[2]);
    }

    private static int[] getPixel(int[] input, int width, int height, int col, int row, float error, int[] ergb) {
        if (col < 0 || col >= width) {
            col = 0;
        }
        if (row < 0 || row >= height) {
            row = 0;
        }
        int index = row * width + col;
        int tr = input[index] >> 16 & 0xFF;
        int tg = input[index] >> 8 & 0xFF;
        int tb = input[index] & 0xFF;
        tr = (int)((float)tr + error * (float)ergb[0]);
        tg = (int)((float)tg + error * (float)ergb[1]);
        tb = (int)((float)tb + error * (float)ergb[2]);
        return new int[]{tr, tg, tb};
    }

    public static int clamp(int value) {
        return value > 255 ? 255 : (value < 0 ? 0 : value);
    }

    public static Bitmap filter(Bitmap nbm, int width, int height) {
        int[] inPixels = new int[width * height];
        nbm.getPixels(inPixels, 0, width, 0, 0, width, height);
        int[] outPixels = new int[inPixels.length];
        int index = 0;
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                float e1;
                index = row * width + col;
                int r1 = inPixels[index] >> 16 & 0xFF;
                int g1 = inPixels[index] >> 8 & 0xFF;
                int b1 = inPixels[index] & 0xFF;
                int cIndex = GpUtils.getCloseColor(r1, g1, b1);
                outPixels[index] = 0xFF000000 | COLOR_PALETTE[cIndex][0] << 16 | COLOR_PALETTE[cIndex][1] << 8 | COLOR_PALETTE[cIndex][2];
                int[] ergb = new int[]{r1 - COLOR_PALETTE[cIndex][0], g1 - COLOR_PALETTE[cIndex][1], b1 - COLOR_PALETTE[cIndex][2]};
                if (method == 1) {
                    e1 = 0.4375f;
                    float e2 = 0.3125f;
                    float e3 = 0.1875f;
                    float e4 = 0.0625f;
                    int[] rgb1 = GpUtils.getPixel(inPixels, width, height, col + 1, row, e1, ergb);
                    int[] rgb2 = GpUtils.getPixel(inPixels, width, height, col, row + 1, e2, ergb);
                    int[] rgb3 = GpUtils.getPixel(inPixels, width, height, col - 1, row + 1, e3, ergb);
                    int[] rgb4 = GpUtils.getPixel(inPixels, width, height, col + 1, row + 1, e4, ergb);
                    GpUtils.setPixel(inPixels, width, height, col + 1, row, rgb1);
                    GpUtils.setPixel(inPixels, width, height, col, row + 1, rgb2);
                    GpUtils.setPixel(inPixels, width, height, col - 1, row + 1, rgb3);
                    GpUtils.setPixel(inPixels, width, height, col + 1, row + 1, rgb4);
                } else if (method == 2) {
                    e1 = 0.125f;
                    int[] rgb1 = GpUtils.getPixel(inPixels, width, height, col + 1, row, e1, ergb);
                    int[] rgb2 = GpUtils.getPixel(inPixels, width, height, col + 2, row, e1, ergb);
                    int[] rgb3 = GpUtils.getPixel(inPixels, width, height, col - 1, row + 1, e1, ergb);
                    int[] rgb4 = GpUtils.getPixel(inPixels, width, height, col, row + 1, e1, ergb);
                    int[] rgb5 = GpUtils.getPixel(inPixels, width, height, col + 1, row + 1, e1, ergb);
                    int[] rgb6 = GpUtils.getPixel(inPixels, width, height, col, row + 2, e1, ergb);
                    GpUtils.setPixel(inPixels, width, height, col + 1, row, rgb1);
                    GpUtils.setPixel(inPixels, width, height, col + 2, row, rgb2);
                    GpUtils.setPixel(inPixels, width, height, col - 1, row + 1, rgb3);
                    GpUtils.setPixel(inPixels, width, height, col, row + 1, rgb4);
                    GpUtils.setPixel(inPixels, width, height, col + 1, row + 1, rgb5);
                    GpUtils.setPixel(inPixels, width, height, col, row + 2, rgb6);
                } else {
                    throw new IllegalArgumentException("Not Supported Dither Mothed!!");
                }
                ++col;
            }
            ++row;
        }
        Bitmap bitmap = Bitmap.createBitmap((int[])outPixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        return bitmap;
    }

    public static byte[] printEscDraw(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] bitbuf = new byte[width / 8];
        byte[] imgbuf = new byte[width / 8 * height + 8];
        imgbuf[0] = 29;
        imgbuf[1] = 118;
        imgbuf[2] = 48;
        imgbuf[3] = 0;
        imgbuf[4] = (byte)(width / 8);
        imgbuf[5] = 0;
        imgbuf[6] = (byte)(height % 256);
        imgbuf[7] = (byte)(height / 256);
        int s = 7;
        int i = 0;
        while (i < height) {
            int k = 0;
            while (k < width / 8) {
                int c0 = bitmap.getPixel(k * 8, i);
                int p0 = c0 == -1 || c0 == 0 ? 0 : 1;
                int c1 = bitmap.getPixel(k * 8 + 1, i);
                int p1 = c1 == -1 ? 0 : 1;
                int c2 = bitmap.getPixel(k * 8 + 2, i);
                int p2 = c2 == -1 ? 0 : 1;
                int c3 = bitmap.getPixel(k * 8 + 3, i);
                int p3 = c3 == -1 ? 0 : 1;
                int c4 = bitmap.getPixel(k * 8 + 4, i);
                int p4 = c4 == -1 ? 0 : 1;
                int c5 = bitmap.getPixel(k * 8 + 5, i);
                int p5 = c5 == -1 ? 0 : 1;
                int c6 = bitmap.getPixel(k * 8 + 6, i);
                int p6 = c6 == -1 ? 0 : 1;
                int c7 = bitmap.getPixel(k * 8 + 7, i);
                int p7 = c7 == -1 ? 0 : 1;
                int value = p0 * 128 + p1 * 64 + p2 * 32 + p3 * 16 + p4 * 8 + p5 * 4 + p6 * 2 + p7;
                bitbuf[k] = (byte)value;
                ++k;
            }
            int t = 0;
            while (t < width / 8) {
                imgbuf[++s] = bitbuf[t];
                ++t;
            }
            ++i;
        }
        return imgbuf;
    }

    public static byte[] printTscDraw(int x, int y, LabelCommand.BITMAP_MODE mode, Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] bitbuf = new byte[width / 8];
        String str = "BITMAP " + x + "," + y + "," + width / 8 + "," + height + "," + mode.getValue() + ",";
        byte[] strPrint = null;
        try {
            strPrint = str.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] imgbuf = new byte[width / 8 * height + strPrint.length + 8];
        int d = 0;
        while (d < strPrint.length) {
            imgbuf[d] = strPrint[d];
            ++d;
        }
        int s = strPrint.length - 1;
        int i = 0;
        while (i < height) {
            int k = 0;
            while (k < width / 8) {
                int c0 = bitmap.getPixel(k * 8, i);
                int p0 = c0 == -1 ? 1 : 0;
                int c1 = bitmap.getPixel(k * 8 + 1, i);
                int p1 = c1 == -1 ? 1 : 0;
                int c2 = bitmap.getPixel(k * 8 + 2, i);
                int p2 = c2 == -1 ? 1 : 0;
                int c3 = bitmap.getPixel(k * 8 + 3, i);
                int p3 = c3 == -1 ? 1 : 0;
                int c4 = bitmap.getPixel(k * 8 + 4, i);
                int p4 = c4 == -1 ? 1 : 0;
                int c5 = bitmap.getPixel(k * 8 + 5, i);
                int p5 = c5 == -1 ? 1 : 0;
                int c6 = bitmap.getPixel(k * 8 + 6, i);
                int p6 = c6 == -1 ? 1 : 0;
                int c7 = bitmap.getPixel(k * 8 + 7, i);
                int p7 = c7 == -1 ? 1 : 0;
                int value = p0 * 128 + p1 * 64 + p2 * 32 + p3 * 16 + p4 * 8 + p5 * 4 + p6 * 2 + p7;
                bitbuf[k] = (byte)value;
                ++k;
            }
            int t = 0;
            while (t < width / 8) {
                imgbuf[++s] = bitbuf[t];
                ++t;
            }
            ++i;
        }
        return imgbuf;
    }

    public static byte[] ZlibpixToLabelCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int k = 0;
        int j = 0;
        while (k < data.length) {
            byte temp;
            data[k] = temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            j += 8;
            ++k;
        }
        return data;
    }

    public static byte[] printZlibTscDraw(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] bitbuf = new byte[width / 8];
        byte[] imgbuf = new byte[width / 8 * height];
        int s = 0;
        int i = 0;
        while (i < height) {
            int t = 0;
            while (t < width / 8) {
                int c0 = bitmap.getPixel(t * 8, i);
                int p0 = c0 == -1 ? 0 : 1;
                int c1 = bitmap.getPixel(t * 8 + 1, i);
                int p1 = c1 == -1 ? 0 : 1;
                int c2 = bitmap.getPixel(t * 8 + 2, i);
                int p2 = c2 == -1 ? 0 : 1;
                int c3 = bitmap.getPixel(t * 8 + 3, i);
                int p3 = c3 == -1 ? 0 : 1;
                int c4 = bitmap.getPixel(t * 8 + 4, i);
                int p4 = c4 == -1 ? 0 : 1;
                int c5 = bitmap.getPixel(t * 8 + 5, i);
                int p5 = c5 == -1 ? 0 : 1;
                int c6 = bitmap.getPixel(t * 8 + 6, i);
                int p6 = c6 == -1 ? 0 : 1;
                int c7 = bitmap.getPixel(t * 8 + 7, i);
                int p7 = c7 == -1 ? 0 : 1;
                int value = p0 * 128 + p1 * 64 + p2 * 32 + p3 * 16 + p4 * 8 + p5 * 4 + p6 * 2 + p7;
                bitbuf[t] = (byte)value;
                ++t;
            }
            t = 0;
            while (t < width / 8) {
                imgbuf[s] = bitbuf[t];
                ++s;
                ++t;
            }
            ++i;
        }
        return imgbuf;
    }

    static String splitArabic(String input) {
        StringBuilder sb = new StringBuilder(256);
        String[] arabics = input.split("\\n");
        if (arabics.length == 1 && arabics[0].length() > sPaperWidth) {
            int insertWrapNumber = arabics[0].length() / sPaperWidth;
            int i = 1;
            int j = 0;
            while (i <= insertWrapNumber) {
                sb.append(arabics[0].substring(j, sPaperWidth * i));
                j += sPaperWidth;
                ++i;
            }
            if (sb.length() >= 0) {
                sb.append('\n');
            }
            int lastArabic = arabics[0].length() % sPaperWidth;
            sb.append(arabics[0].substring(arabics[0].length() - lastArabic, arabics[0].length()));
            return GpUtils.splitArabic(sb.toString());
        }
        int i = 0;
        while (i < arabics.length) {
            int childStringLength = arabics[i].length();
            if (childStringLength > sPaperWidth) {
                sb.append(GpUtils.splitArabic(arabics[i]));
            } else {
                sb.append(GpUtils.addSpaceAfterArabicString(arabics[i], sPaperWidth - childStringLength));
            }
            ++i;
        }
        return sb.toString();
    }

    static String addSpaceAfterArabicString(String arabic, int number) {
        StringBuilder sb = new StringBuilder(65);
        sb.append(arabic);
        int i = 0;
        while (i < number) {
            sb.append(' ');
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }

    static String reverseLetterAndNumber(String input) {
        StringBuilder sb = new StringBuilder(input);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String matcherString = matcher.group();
            int matcherStart = matcher.start();
            int matcherEnd = matcher.end();
            sb.replace(matcherStart, matcherEnd, new StringBuilder(matcherString).reverse().toString());
        }
        return sb.toString();
    }

    static byte[] string2Cp864(String arabicString) {
        Integer[] originUnicode = new Integer[arabicString.length()];
        Integer[] outputUnicode = new Integer[arabicString.length()];
        Integer[] outputChars = new Integer[originUnicode.length];
        GpUtils.copy(arabicString.toCharArray(), originUnicode, arabicString.length());
        List<Integer> list = new ArrayList<Integer>(Arrays.asList(originUnicode));
        list = GpUtils.Hyphen(list);
        list = GpUtils.Deformation(list);
        Collections.reverse(list);
        list.toArray(outputUnicode);
        char[] chs = GpUtils.integer2Character(outputUnicode);
        byte[] cp864bytes = new byte[]{};
        try {
            cp864bytes = new String(chs).getBytes("cp864");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return cp864bytes;
    }

    static char[] integer2Character(Integer[] integers) {
        char[] chs = new char[integers.length];
        int i = 0;
        while (i < integers.length) {
            chs[i] = integers[i] != null ? (int)integers[i] : 32;
            ++i;
        }
        return chs;
    }

    static void copy(char[] array, Integer[] originUnicode, int length) {
        int i = 0;
        while (i < length) {
            originUnicode[i] = array[i];
            ++i;
        }
    }

    static List<Integer> Hyphen(List<Integer> list) {
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == 1604) {
                switch (list.get(i + 1)) {
                    case 1570: {
                        list.set(i, 17442);
                        list.remove(i + 1);
                        break;
                    }
                    case 1571: {
                        list.set(i, 17443);
                        list.remove(i + 1);
                        break;
                    }
                    case 1573: {
                        list.set(i, 17445);
                        list.remove(i + 1);
                        break;
                    }
                    case 1575: {
                        list.set(i, 17447);
                        list.remove(i + 1);
                    }
                }
            }
            ++i;
        }
        return list;
    }

    static List<Integer> Deformation(List<Integer> inputlist) {
        int flag = 0;
        ArrayList<Integer> outputlist = new ArrayList<Integer>();
        HashMap<Integer, Integer[]> formHashTable = new HashMap<Integer, Integer[]>(40);
        int i = 0;
        while (i < 40) {
            formHashTable.put(theSet0[i], FormatTable[i]);
            ++i;
        }
        i = 0;
        while (i < inputlist.size()) {
            if (GpUtils.compare(inputlist.get(i), 0)) {
                boolean inSet2;
                boolean inSet1;
                if (i == 0) {
                    inSet1 = false;
                    inSet2 = GpUtils.compare(inputlist.get(i + 1), 2);
                    flag = GpUtils.Flag(inSet1, inSet2);
                } else if (i == inputlist.size() - 1) {
                    inSet1 = GpUtils.compare(inputlist.get(i - 1), 1);
                    inSet2 = false;
                    flag = GpUtils.Flag(inSet1, inSet2);
                } else {
                    inSet1 = GpUtils.compare(inputlist.get(i - 1), 1);
                    inSet2 = GpUtils.compare(inputlist.get(i + 1), 2);
                    flag = GpUtils.Flag(inSet1, inSet2);
                }
                Integer[] a = (Integer[])formHashTable.get(inputlist.get(i));
                outputlist.add(a[flag]);
            } else {
                outputlist.add(inputlist.get(i));
            }
            ++i;
        }
        return outputlist;
    }

    static boolean compare(Integer input, int i) {
        ArrayList<Integer[]> list = new ArrayList<Integer[]>(3);
        list.add(theSet0);
        list.add(theSet1);
        list.add(theSet2);
        return GpUtils.findInArray((Integer[])list.get(i), input);
    }

    static boolean findInArray(Integer[] integer, int input) {
        int j = 0;
        while (j < integer.length) {
            if (integer[j] == input) {
                return true;
            }
            ++j;
        }
        return false;
    }

    static int Flag(boolean set1, boolean set2) {
        if (set1 && set2) {
            return 3;
        }
        if (!set1 && set2) {
            return 2;
        }
        if (set1 && !set2) {
            return 1;
        }
        return 0;
    }

    public static void setPaperWidth(int paperWidth) {
        sPaperWidth = paperWidth;
    }

    public static byte[] ByteTo_byte(Vector<Byte> vector) {
        int len = vector.size();
        byte[] data = new byte[len];
        int i = 0;
        while (i < len) {
            data[i] = vector.get(i);
            ++i;
        }
        return data;
    }

    public int getMethod() {
        return method;
    }

    public static void setMethod(int method) {
        GpUtils.method = method;
    }
}

