/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.text.TextUtils;
import com.gprinter.utils.PrinterTool;

public class FactoryCommand {
    String TAG = FactoryCommand.class.getSimpleName();

    public static byte[] changPrinterMode(printerMode mode) {
        byte[] b = new byte[]{31, 27, 31, -4, 1, 2, 3, 51};
        if (mode == printerMode.ESC) {
            b[7] = 85;
        }
        if (mode == printerMode.TSC) {
            b[7] = 51;
        }
        if (mode == printerMode.CPCL) {
            b[7] = 68;
        }
        return b;
    }

    public static byte[] setPrinterEscPidVid(VidPid vid, VidPid pid) {
        byte[] byArray = new byte[11];
        byArray[0] = 31;
        byArray[1] = 27;
        byArray[2] = 31;
        byArray[3] = 36;
        byArray[4] = 4;
        byArray[5] = 6;
        byArray[6] = 7;
        byArray[7] = 104;
        byArray[8] = 104;
        byArray[9] = 5;
        byte[] cmd = byArray;
        if (vid == VidPid.VID6868) {
            cmd[7] = 104;
            cmd[8] = 104;
        }
        if (vid == VidPid.VID0471) {
            cmd[7] = 4;
            cmd[8] = 113;
        }
        if (pid == VidPid.PID0500) {
            cmd[9] = 5;
            cmd[10] = 0;
        }
        if (pid == VidPid.PID0100) {
            cmd[9] = 1;
            cmd[10] = 0;
        }
        if (pid == VidPid.PID0055) {
            cmd[9] = 0;
            cmd[10] = 85;
        }
        return cmd;
    }

    public static byte[] setPrinterTscPidVid(VidPid vid, VidPid pid) {
        String labelCmd = "SET USB_VID_PID ";
        if (vid == VidPid.VID6868) {
            labelCmd = String.valueOf(labelCmd) + (Object)((Object)VidPid.VID6868);
        }
        if (vid == VidPid.VID0471) {
            labelCmd = String.valueOf(labelCmd) + (Object)((Object)VidPid.VID0471);
        }
        if (pid == VidPid.PID0500) {
            labelCmd = String.valueOf(labelCmd) + " " + (Object)((Object)VidPid.PID0500);
        }
        if (pid == VidPid.PID0100) {
            labelCmd = String.valueOf(labelCmd) + " " + (Object)((Object)VidPid.PID0500);
        }
        if (pid == VidPid.PID0055) {
            labelCmd = String.valueOf(labelCmd) + " " + (Object)((Object)VidPid.PID0055);
        }
        labelCmd = String.valueOf(labelCmd) + "\r\n";
        return labelCmd.getBytes();
    }

    public static byte[] setFont(Character width, Character height, ChineseFont chineseWidth, ChineseFont chineseHeight) {
        byte[] byArray = new byte[11];
        byArray[0] = 31;
        byArray[1] = 27;
        byArray[2] = 31;
        byArray[3] = -77;
        byArray[4] = 2;
        byArray[5] = 3;
        byArray[6] = 4;
        byte[] bytes = byArray;
        if (width == Character.zoomFont) {
            bytes[7] = 1;
        }
        if (height == Character.zoomFont) {
            bytes[8] = 1;
        }
        if (chineseWidth == ChineseFont.zoomFont) {
            bytes[9] = 1;
        }
        if (chineseHeight == ChineseFont.zoomFont) {
            bytes[10] = 1;
        }
        return bytes;
    }

    public static byte[] checkPower() {
        byte[] b = new byte[]{31, 27, 31, -88, 16, 17, 18, 19, 20, 21, 119};
        return b;
    }

    public static byte[] printSelfTest(printerMode mode) {
        byte[] b = new byte[12];
        if (mode == printerMode.ESC) {
            byte[] byArray = new byte[12];
            byArray[0] = 31;
            byArray[1] = 27;
            byArray[2] = 31;
            byArray[3] = -109;
            byArray[4] = 16;
            byArray[5] = 17;
            byArray[6] = 18;
            byArray[7] = 21;
            byArray[8] = 22;
            byArray[9] = 23;
            byArray[10] = 16;
            b = byArray;
            return b;
        }
        if (mode == printerMode.TSC) {
            return "SELFTEST\r\n".getBytes();
        }
        return b;
    }

    public static byte[] blueToothName(String name) {
        if (!TextUtils.isEmpty((CharSequence)name) && name.length() > 0 && name.length() < 9) {
            byte[] name_command = new byte[]{31, 27, 31, -80, 2, 3, 4, (byte)name.length()};
            byte[] b_name = PrinterTool.addBytes(name_command, name.getBytes());
            return b_name;
        }
        return null;
    }

    public static byte[] blueToothPIN(String pin) {
        if (!TextUtils.isEmpty((CharSequence)pin) && pin.length() == 4 && PrinterTool.checkPairCode(pin)) {
            byte[] pin_command = new byte[]{31, 27, 31, -79, 2, 3, 4};
            byte[] b_pin = PrinterTool.addBytes(pin_command, pin.getBytes());
            return b_pin;
        }
        return null;
    }

    public static byte[] setIP(String ip) {
        if (!TextUtils.isEmpty((CharSequence)ip) && PrinterTool.checkIP(ip)) {
            String[] temp = ip.split("\\.");
            int ip0 = Integer.valueOf(temp[0]);
            int ip1 = Integer.valueOf(temp[1]);
            int ip2 = Integer.valueOf(temp[2]);
            int ip3 = Integer.valueOf(temp[3]);
            byte[] byArray = new byte[11];
            byArray[0] = 31;
            byArray[1] = 27;
            byArray[2] = 31;
            byArray[3] = -111;
            byArray[5] = 73;
            byArray[6] = 80;
            byArray[7] = (byte)ip0;
            byArray[8] = (byte)ip1;
            byArray[9] = (byte)ip2;
            byArray[10] = (byte)ip3;
            byte[] byArray2 = byArray;
        }
        return null;
    }

    public static byte[] setMac(byte[] mac) {
        if (mac != null && mac.length == 6) {
            byte[] byArray = new byte[13];
            byArray[0] = 31;
            byArray[1] = 27;
            byArray[2] = 31;
            byArray[3] = -111;
            byArray[5] = 73;
            byArray[6] = 68;
            byArray[7] = mac[0];
            byArray[8] = mac[1];
            byArray[9] = mac[2];
            byArray[10] = mac[3];
            byArray[11] = mac[4];
            byArray[12] = mac[5];
            byte[] mac_command = byArray;
            return mac_command;
        }
        return null;
    }

    public static byte[] setMask(String mask) {
        if (!TextUtils.isEmpty((CharSequence)mask) && PrinterTool.checkIP(mask)) {
            String[] temp = mask.split("\\.");
            int mask0 = Integer.valueOf(temp[0]);
            int mask1 = Integer.valueOf(temp[1]);
            int mask2 = Integer.valueOf(temp[2]);
            int mask3 = Integer.valueOf(temp[3]);
            byte[] byArray = new byte[11];
            byArray[0] = 31;
            byArray[1] = 27;
            byArray[2] = 31;
            byArray[3] = -111;
            byArray[5] = 73;
            byArray[6] = 69;
            byArray[7] = (byte)mask0;
            byArray[8] = (byte)mask1;
            byArray[9] = (byte)mask2;
            byArray[10] = (byte)mask3;
            byte[] byArray2 = byArray;
        }
        return null;
    }

    public static byte[] setGateway(String gateway) {
        if (!TextUtils.isEmpty((CharSequence)gateway) && PrinterTool.checkIP(gateway)) {
            String[] temp = gateway.split("\\.");
            int gateway0 = Integer.valueOf(temp[0]);
            int gateway1 = Integer.valueOf(temp[1]);
            int gateway2 = Integer.valueOf(temp[2]);
            int gateway3 = Integer.valueOf(temp[3]);
            byte[] byArray = new byte[11];
            byArray[0] = 31;
            byArray[1] = 27;
            byArray[2] = 31;
            byArray[3] = -111;
            byArray[5] = 73;
            byArray[6] = 70;
            byArray[7] = (byte)gateway0;
            byArray[8] = (byte)gateway1;
            byArray[9] = (byte)gateway2;
            byArray[10] = (byte)gateway3;
            byte[] byArray2 = byArray;
        }
        return null;
    }

    public static enum Character {
        defaultFont(0),
        zoomFont(1);

        private final int value;

        private Character(int value) {
            this.value = value;
        }

        public int getCharacter() {
            return this.value;
        }
    }

    public static enum ChineseFont {
        defaultFont(0),
        zoomFont(1);

        private final int value;

        private ChineseFont(int value) {
            this.value = value;
        }

        public int getChineseFont() {
            return this.value;
        }
    }

    public static enum VidPid {
        VID6868(6868),
        VID0471(313),
        PID0500(320),
        PID0100(64),
        PID0055(45);

        private final int value;

        private VidPid(int value) {
            this.value = value;
        }

        public int getVidPid() {
            return this.value;
        }
    }

    public static enum printerMode {
        ESC(0),
        TSC(1),
        CPCL(2);

        private final int value;

        private printerMode(int value) {
            this.value = value;
        }

        public byte getPrinterMode() {
            return (byte)this.value;
        }
    }
}

