/*
 * Decompiled with CFR 0.152.
 */
package com.speed.print;

import android.util.Log;
import com.speed.print.ThreadFactoryBuilder;
import java.util.ArrayDeque;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private Runnable mActive;
    private static ThreadPool threadPool;
    private ThreadPoolExecutor threadPoolExecutor;
    private static final int CPU_AVAILABLE;
    private static final int MAX_POOL_COUNTS;
    private static final long AVAILABLE = 1L;
    private static final int CORE_POOL_SIZE;
    private BlockingQueue<Runnable> mWorkQueue = new ArrayBlockingQueue<Runnable>(CORE_POOL_SIZE);
    private ArrayDeque<Runnable> mArrayDeque = new ArrayDeque();
    private ThreadFactory threadFactory = new ThreadFactoryBuilder("ThreadPool");

    private ThreadPool() {
        this.threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_COUNTS, 1L, TimeUnit.SECONDS, this.mWorkQueue, this.threadFactory);
    }

    public static ThreadPool getInstantiation() {
        if (threadPool == null) {
            threadPool = new ThreadPool();
        }
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParallelTask(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("addTask(Runnable runnable)\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.threadPoolExecutor.getActiveCount() < MAX_POOL_COUNTS) {
            Log.i((String)"Lee", (String)("\u76ee\u524d\u6709" + this.threadPoolExecutor.getActiveCount() + "\u4e2a\u7ebf\u7a0b\u6b63\u5728\u8fdb\u884c\u4e2d,\u6709" + this.mWorkQueue.size() + "\u4e2a\u4efb\u52a1\u6b63\u5728\u6392\u961f"));
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                this.threadPoolExecutor.execute(runnable);
            }
        }
    }

    public synchronized void addSerialTask(final Runnable r) {
        if (r == null) {
            throw new NullPointerException("addTask(Runnable runnable)\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        this.mArrayDeque.offer(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    ThreadPool.this.scheduleNext();
                }
            }
        });
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    private void scheduleNext() {
        this.mActive = this.mArrayDeque.poll();
        if (this.mActive != null) {
            this.threadPoolExecutor.execute(this.mActive);
        }
    }

    public void stopThreadPool() {
        if (this.threadPoolExecutor != null) {
            this.threadPoolExecutor.shutdown();
            this.threadPoolExecutor = null;
            threadPool = null;
        }
    }

    static {
        CPU_AVAILABLE = Runtime.getRuntime().availableProcessors();
        MAX_POOL_COUNTS = CPU_AVAILABLE * 2 + 1;
        CORE_POOL_SIZE = CPU_AVAILABLE + 1;
    }
}

