/*
 * Decompiled with CFR 0.152.
 */
package com.speed.print;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import com.speed.print.DeviceConnFactoryManager;
import com.speed.print.PrinterCommand;
import com.speed.print.ThreadPool;
import com.speed.print.Utils;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;

public class PrintManager {
    private static Context mContext;
    private ArrayList<String> mConnectedDeviceList;
    private BluetoothAdapter mBluetoothAdapter;
    private int id = 0;
    private ThreadPool mThreadPool;
    private PrintStateCallBack mPrintStateCallBack;
    private static final int PRINTER_COMMAND_ERROR = 8;
    public static final int BLUETOOTH_NOT_LINK = 9;
    public static final int REQUEST_ENABLE_BT = 16;

    private PrintManager() {
    }

    public static PrintManager getInstance(Context context) {
        mContext = context;
        return SingleTonHolder.INSTANCE;
    }

    public boolean initBluetooth() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            Utils.toast(mContext, "\u5f53\u524d\u8bbe\u5907\u4e0d\u652f\u6301\u84dd\u7259");
        } else if (!this.mBluetoothAdapter.isEnabled()) {
            if (this.mPrintStateCallBack != null) {
                this.mPrintStateCallBack.onError(9, "\u84dd\u7259\u529f\u80fd\u672a\u6253\u5f00");
            }
        } else if (!this.isPrintLink()) {
            Utils.toast(mContext, "\u6b63\u5728\u8fde\u63a5\u6253\u5370\u673a");
            return this.initPairedDevice();
        }
        return false;
    }

    public boolean initPairedDevice() {
        this.mConnectedDeviceList = new ArrayList();
        Set pairedDevices = this.mBluetoothAdapter.getBondedDevices();
        if (pairedDevices.size() > 0) {
            for (BluetoothDevice device : pairedDevices) {
                if (device.getName() == null || !device.getName().startsWith("Printer_")) continue;
                this.mConnectedDeviceList.add(device.getAddress());
            }
            if (this.mConnectedDeviceList.size() == 0) {
                return false;
            }
            this.closePort();
            new DeviceConnFactoryManager.Build().setId(this.id).setConnMethod(DeviceConnFactoryManager.CONN_METHOD.BLUETOOTH).setMacAddress(this.mConnectedDeviceList.get(0)).setContext(mContext).build();
            this.mThreadPool = ThreadPool.getInstantiation();
            this.mThreadPool.addSerialTask(new Runnable(){

                @Override
                public void run() {
                    DeviceConnFactoryManager.getDeviceConnFactoryManagers()[PrintManager.this.id].openPort();
                }
            });
            return true;
        }
        Utils.toast(mContext, "\u8bf7\u5148\u5c06\u6253\u5370\u673a\u4e0e\u624b\u673a\u8fdb\u884c\u84dd\u7259\u914d\u5bf9");
        return false;
    }

    private void closePort() {
        if (DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id] != null && DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id].mPort != null) {
            DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id].cancel();
            DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id].mPort.closePort();
            DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id].mPort = null;
        }
    }

    public boolean isPrintLink() {
        boolean isLink = DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id] != null && DeviceConnFactoryManager.getDeviceConnFactoryManagers()[this.id].getConnState();
        return isLink;
    }

    public void btnReceiptPrint(final Vector<Byte> printContent) {
        if (!this.mBluetoothAdapter.isEnabled()) {
            if (this.mPrintStateCallBack != null) {
                this.mPrintStateCallBack.onError(9, "\u84dd\u7259\u529f\u80fd\u672a\u6253\u5f00");
            }
            return;
        }
        if (!this.isPrintLink()) {
            return;
        }
        this.mThreadPool = ThreadPool.getInstantiation();
        this.mThreadPool.addSerialTask(new Runnable(){

            @Override
            public void run() {
                if (DeviceConnFactoryManager.getDeviceConnFactoryManagers()[PrintManager.this.id].getCurrentPrinterCommand() == PrinterCommand.ESC) {
                    DeviceConnFactoryManager.getDeviceConnFactoryManagers()[PrintManager.this.id].sendDataImmediately(printContent);
                    if (PrintManager.this.mPrintStateCallBack != null) {
                        PrintManager.this.mPrintStateCallBack.onResponse("\u6253\u5370\u6210\u529f");
                    }
                } else if (PrintManager.this.mPrintStateCallBack != null) {
                    PrintManager.this.mPrintStateCallBack.onError(8, "\u6253\u5370\u673a\u547d\u4ee4\u9519\u8bef");
                }
            }
        });
    }

    public void onDestory() {
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        this.mBluetoothAdapter = null;
        DeviceConnFactoryManager.closeAllPort();
        if (this.mThreadPool != null) {
            this.mThreadPool.stopThreadPool();
        }
        this.mThreadPool = null;
        this.mConnectedDeviceList = null;
    }

    public void setPrintStateCallBack(PrintStateCallBack printStateCallBack) {
        this.mPrintStateCallBack = printStateCallBack;
    }

    public static interface PrintStateCallBack {
        public void onResponse(String var1);

        public void onError(int var1, String var2);
    }

    private static class SingleTonHolder {
        private static final PrintManager INSTANCE = new PrintManager();

        private SingleTonHolder() {
        }
    }
}

