/*
 * Decompiled with CFR 0.152.
 */
package com.speed.print;

import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.gprinter.io.BluetoothPort;
import com.gprinter.io.EthernetPort;
import com.gprinter.io.PortManager;
import com.gprinter.io.SerialPort;
import com.gprinter.io.UsbPort;
import com.shanxian.printer.R;
import com.speed.print.PrinterCommand;
import com.speed.print.ThreadFactoryBuilder;
import com.speed.print.ThreadPool;
import com.speed.print.Utils;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DeviceConnFactoryManager {
    public PortManager mPort;
    private static final String TAG = DeviceConnFactoryManager.class.getSimpleName();
    public CONN_METHOD connMethod;
    private String ip;
    private int port;
    private String macAddress;
    private UsbDevice mUsbDevice;
    private Context mContext;
    private String serialPortPath;
    private int baudrate;
    private int id;
    private static DeviceConnFactoryManager[] deviceConnFactoryManagers = new DeviceConnFactoryManager[4];
    private boolean isOpenPort;
    private byte[] esc = new byte[]{16, 4, 2};
    private static final int ESC_STATE_PAPER_ERR = 32;
    private static final int ESC_STATE_COVER_OPEN = 4;
    private static final int ESC_STATE_ERR_OCCURS = 64;
    private byte[] tsc = new byte[]{27, 33, 63};
    private static final int TSC_STATE_PAPER_ERR = 4;
    private static final int TSC_STATE_COVER_OPEN = 1;
    private static final int TSC_STATE_ERR_OCCURS = 128;
    private static final int DEFAUIT_COMMAND = 20000;
    private static final int CPCL_STATE_PAPER_ERR = 1;
    private static final int CPCL_STATE_COVER_OPEN = 2;
    private byte[] sendCommand;
    private PrinterCommand currentPrinterCommand;
    public static final byte FLAG = 16;
    private static final int READ_DATA = 10000;
    private byte[] cpcl = new byte[]{27, 104};
    private static final String READ_DATA_CNT = "read_data_cnt";
    private static final String READ_BUFFER_ARRAY = "read_buffer_array";
    public static final String ACTION_CONN_STATE = "action_connect_state";
    public static final String ACTION_QUERY_PRINTER_STATE = "action_query_printer_state";
    public static final String STATE = "state";
    public static final String DEVICE_ID = "id";
    public static final int CONN_STATE_DISCONNECT = 144;
    public static final int CONN_STATE_CONNECTING = 288;
    public static final int CONN_STATE_FAILED = 576;
    public static final int CONN_STATE_CONNECTED = 1152;
    public PrinterReader reader;
    private int queryPrinterCommandFlag;
    private final int ESC = 1;
    private final int TSC = 3;
    private final int CPCL = 2;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 17: {
                    Utils.toast(DeviceConnFactoryManager.this.mContext, DeviceConnFactoryManager.this.mContext.getString(R.string.str_disconnect));
                    break;
                }
                case 20000: {
                    Utils.toast(DeviceConnFactoryManager.this.mContext, DeviceConnFactoryManager.this.mContext.getString(R.string.default_mode));
                    break;
                }
                case 10000: {
                    int cnt = msg.getData().getInt(DeviceConnFactoryManager.READ_DATA_CNT);
                    byte[] buffer = msg.getData().getByteArray(DeviceConnFactoryManager.READ_BUFFER_ARRAY);
                    if (buffer == null) {
                        return;
                    }
                    int result = DeviceConnFactoryManager.this.judgeResponseType(buffer[0]);
                    String status = DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_conn_normal);
                    if (DeviceConnFactoryManager.this.sendCommand == DeviceConnFactoryManager.this.esc) {
                        if (DeviceConnFactoryManager.this.currentPrinterCommand == null) {
                            DeviceConnFactoryManager.this.currentPrinterCommand = PrinterCommand.ESC;
                            DeviceConnFactoryManager.this.sendStateBroadcast(1152);
                            Utils.toast(DeviceConnFactoryManager.this.mContext, "\u6253\u5370\u673a\u8fde\u63a5\u6210\u529f");
                            break;
                        }
                        if (result == 0) {
                            Intent intent = new Intent(DeviceConnFactoryManager.ACTION_QUERY_PRINTER_STATE);
                            intent.putExtra(DeviceConnFactoryManager.DEVICE_ID, DeviceConnFactoryManager.this.id);
                            DeviceConnFactoryManager.this.mContext.sendBroadcast(intent);
                            break;
                        }
                        if (result != 1) break;
                        break;
                    }
                    if (DeviceConnFactoryManager.this.sendCommand == DeviceConnFactoryManager.this.tsc) {
                        if (DeviceConnFactoryManager.this.currentPrinterCommand == null) {
                            DeviceConnFactoryManager.this.currentPrinterCommand = PrinterCommand.TSC;
                            DeviceConnFactoryManager.this.sendStateBroadcast(1152);
                            Utils.toast(DeviceConnFactoryManager.this.mContext, DeviceConnFactoryManager.this.mContext.getString(R.string.str_tscmode));
                            break;
                        }
                        if (cnt == 1) {
                            if ((buffer[0] & 4) > 0) {
                                status = status + " " + DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_out_of_paper);
                            }
                            if ((buffer[0] & 1) > 0) {
                                status = status + " " + DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_open_cover);
                            }
                            if ((buffer[0] & 0x80) > 0) {
                                status = status + " " + DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_error);
                            }
                            System.out.println(DeviceConnFactoryManager.this.mContext.getString(R.string.str_state) + status);
                            String mode = DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_printmode_tsc);
                            Utils.toast(DeviceConnFactoryManager.this.mContext, mode + " " + status);
                            break;
                        }
                        Intent intent = new Intent(DeviceConnFactoryManager.ACTION_QUERY_PRINTER_STATE);
                        intent.putExtra(DeviceConnFactoryManager.DEVICE_ID, DeviceConnFactoryManager.this.id);
                        DeviceConnFactoryManager.this.mContext.sendBroadcast(intent);
                        break;
                    }
                    if (DeviceConnFactoryManager.this.sendCommand != DeviceConnFactoryManager.this.cpcl) break;
                    if (DeviceConnFactoryManager.this.currentPrinterCommand == null) {
                        DeviceConnFactoryManager.this.currentPrinterCommand = PrinterCommand.CPCL;
                        DeviceConnFactoryManager.this.sendStateBroadcast(1152);
                        break;
                    }
                    if (cnt == 1) {
                        System.out.println(DeviceConnFactoryManager.this.mContext.getString(R.string.str_state) + status);
                        if (buffer[0] == 1) {
                            status = status + " " + DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_out_of_paper);
                        }
                        if (buffer[0] == 2) {
                            status = status + " " + DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_open_cover);
                        }
                        String mode = DeviceConnFactoryManager.this.mContext.getString(R.string.str_printer_printmode_cpcl);
                        Utils.toast(DeviceConnFactoryManager.this.mContext, mode + " " + status);
                        break;
                    }
                    Intent intent = new Intent(DeviceConnFactoryManager.ACTION_QUERY_PRINTER_STATE);
                    intent.putExtra(DeviceConnFactoryManager.DEVICE_ID, DeviceConnFactoryManager.this.id);
                    DeviceConnFactoryManager.this.mContext.sendBroadcast(intent);
                    break;
                }
            }
        }
    };

    public static DeviceConnFactoryManager[] getDeviceConnFactoryManagers() {
        return deviceConnFactoryManagers;
    }

    private void queryCommand() {
        this.reader = new PrinterReader();
        this.reader.start();
        this.queryPrinterCommand();
    }

    public CONN_METHOD getConnMethod() {
        return this.connMethod;
    }

    public boolean getConnState() {
        return this.isOpenPort;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getIp() {
        return this.ip;
    }

    public UsbDevice usbDevice() {
        return this.mUsbDevice;
    }

    public void openPort() {
        DeviceConnFactoryManager.deviceConnFactoryManagers[this.id].isOpenPort = false;
        this.sendStateBroadcast(288);
        switch (DeviceConnFactoryManager.deviceConnFactoryManagers[this.id].connMethod) {
            case BLUETOOTH: {
                this.mPort = new BluetoothPort(this.macAddress);
                this.isOpenPort = DeviceConnFactoryManager.deviceConnFactoryManagers[this.id].mPort.openPort();
                break;
            }
            case USB: {
                this.mPort = new UsbPort(this.mContext, this.mUsbDevice);
                this.isOpenPort = this.mPort.openPort();
                break;
            }
            case WIFI: {
                this.mPort = new EthernetPort(this.ip, this.port);
                this.isOpenPort = this.mPort.openPort();
                break;
            }
            case SERIAL_PORT: {
                this.mPort = new SerialPort(this.serialPortPath, this.baudrate, 0);
                this.isOpenPort = this.mPort.openPort();
                break;
            }
        }
        if (this.isOpenPort) {
            this.queryCommand();
        } else {
            if (this.mPort != null) {
                this.mPort = null;
            }
            this.sendStateBroadcast(576);
        }
    }

    public String getSerialPortPath() {
        return this.serialPortPath;
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public static void closeAllPort() {
        for (DeviceConnFactoryManager deviceConnFactoryManager : deviceConnFactoryManagers) {
            if (deviceConnFactoryManager == null) continue;
            Log.e((String)TAG, (String)("cloaseAllPort() id -> " + deviceConnFactoryManager.id));
            deviceConnFactoryManager.closePort(deviceConnFactoryManager.id);
            DeviceConnFactoryManager.deviceConnFactoryManagers[deviceConnFactoryManager.id] = null;
        }
    }

    private DeviceConnFactoryManager(Build build) {
        this.connMethod = build.connMethod;
        this.macAddress = build.macAddress;
        this.port = build.port;
        this.ip = build.ip;
        this.mUsbDevice = build.usbDevice;
        this.mContext = build.context;
        this.serialPortPath = build.serialPortPath;
        this.baudrate = build.baudrate;
        this.id = build.id;
        DeviceConnFactoryManager.deviceConnFactoryManagers[this.id] = this;
    }

    public PrinterCommand getCurrentPrinterCommand() {
        return DeviceConnFactoryManager.deviceConnFactoryManagers[this.id].currentPrinterCommand;
    }

    public void sendDataImmediately(Vector<Byte> data) {
        if (this.mPort == null) {
            return;
        }
        try {
            this.mPort.writeDataImmediately(data, 0, data.size());
        }
        catch (Exception e) {
            this.mHandler.obtainMessage(17).sendToTarget();
        }
    }

    public void closePort(int id) {
        if (this.mPort != null) {
            boolean b;
            if (this.reader != null) {
                this.reader.cancel();
                this.reader = null;
            }
            if (b = this.mPort.closePort()) {
                this.mPort = null;
                this.isOpenPort = false;
                this.currentPrinterCommand = null;
            }
        }
        this.sendStateBroadcast(144);
    }

    public int readDataImmediately(byte[] buffer) throws IOException {
        return this.mPort.readData(buffer);
    }

    public void sendByteDataImmediately(byte[] data) {
        if (this.mPort == null) {
            return;
        }
        Vector<Byte> datas = new Vector<Byte>();
        for (int i = 0; i < data.length; ++i) {
            datas.add(data[i]);
        }
        try {
            this.mPort.writeDataImmediately(datas, 0, datas.size());
        }
        catch (IOException e) {
            this.mHandler.obtainMessage(17).sendToTarget();
        }
    }

    private void queryPrinterCommand() {
        this.queryPrinterCommandFlag = 1;
        ThreadPool.getInstantiation().addSerialTask(new Runnable(){

            @Override
            public void run() {
                ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder("Timer");
                final ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, threadFactoryBuilder);
                scheduledExecutorService.scheduleAtFixedRate(threadFactoryBuilder.newThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DeviceConnFactoryManager.this.currentPrinterCommand == null && DeviceConnFactoryManager.this.queryPrinterCommandFlag > 3) {
                            if (DeviceConnFactoryManager.this.getConnMethod() == CONN_METHOD.USB) {
                                DeviceConnFactoryManager.this.currentPrinterCommand = PrinterCommand.ESC;
                                DeviceConnFactoryManager.this.sendStateBroadcast(1152);
                                DeviceConnFactoryManager.access$202(DeviceConnFactoryManager.this, DeviceConnFactoryManager.this.esc);
                                DeviceConnFactoryManager.this.mHandler.sendMessage(DeviceConnFactoryManager.this.mHandler.obtainMessage(20000, (Object)""));
                                scheduledExecutorService.shutdown();
                            } else if (DeviceConnFactoryManager.this.reader != null) {
                                DeviceConnFactoryManager.this.reader.cancel();
                                DeviceConnFactoryManager.this.mPort.closePort();
                                DeviceConnFactoryManager.this.isOpenPort = false;
                                DeviceConnFactoryManager.this.sendStateBroadcast(576);
                                scheduledExecutorService.shutdown();
                            }
                        }
                        if (DeviceConnFactoryManager.this.currentPrinterCommand != null) {
                            if (scheduledExecutorService != null && !scheduledExecutorService.isShutdown()) {
                                scheduledExecutorService.shutdown();
                            }
                            return;
                        }
                        switch (DeviceConnFactoryManager.this.queryPrinterCommandFlag) {
                            case 1: {
                                DeviceConnFactoryManager.access$202(DeviceConnFactoryManager.this, DeviceConnFactoryManager.this.esc);
                                break;
                            }
                            case 3: {
                                DeviceConnFactoryManager.access$202(DeviceConnFactoryManager.this, DeviceConnFactoryManager.this.tsc);
                                break;
                            }
                            case 2: {
                                DeviceConnFactoryManager.access$202(DeviceConnFactoryManager.this, DeviceConnFactoryManager.this.cpcl);
                                break;
                            }
                        }
                        Vector<Byte> data = new Vector<Byte>(DeviceConnFactoryManager.this.sendCommand.length);
                        for (int i = 0; i < DeviceConnFactoryManager.this.sendCommand.length; ++i) {
                            data.add(DeviceConnFactoryManager.this.sendCommand[i]);
                        }
                        DeviceConnFactoryManager.this.sendDataImmediately(data);
                        DeviceConnFactoryManager.this.queryPrinterCommandFlag++;
                    }
                }), 1500L, 1500L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public void cancel() {
        if (this.reader != null) {
            this.reader.cancel();
        }
    }

    private void sendStateBroadcast(int state) {
        Intent intent = new Intent(ACTION_CONN_STATE);
        intent.putExtra(STATE, state);
        intent.putExtra(DEVICE_ID, this.id);
        this.mContext.sendBroadcast(intent);
    }

    private int judgeResponseType(byte r) {
        return (byte)((r & 0x10) >> 4);
    }

    static /* synthetic */ byte[] access$202(DeviceConnFactoryManager x0, byte[] x1) {
        x0.sendCommand = x1;
        return x1;
    }

    class PrinterReader
    extends Thread {
        private boolean isRun = true;
        private byte[] buffer = new byte[100];

        @Override
        public void run() {
            block3: {
                try {
                    while (this.isRun) {
                        Log.e((String)TAG, (String)"wait read ");
                        int len = DeviceConnFactoryManager.this.readDataImmediately(this.buffer);
                        Log.e((String)TAG, (String)(" read " + len));
                        if (len <= 0) continue;
                        Message message = Message.obtain();
                        message.what = 10000;
                        Bundle bundle = new Bundle();
                        bundle.putInt(DeviceConnFactoryManager.READ_DATA_CNT, len);
                        bundle.putByteArray(DeviceConnFactoryManager.READ_BUFFER_ARRAY, this.buffer);
                        message.setData(bundle);
                        DeviceConnFactoryManager.this.mHandler.sendMessage(message);
                    }
                }
                catch (Exception e) {
                    if (deviceConnFactoryManagers[DeviceConnFactoryManager.this.id] == null) break block3;
                    DeviceConnFactoryManager.this.closePort(DeviceConnFactoryManager.this.id);
                    DeviceConnFactoryManager.this.mHandler.obtainMessage(17).sendToTarget();
                }
            }
        }

        public void cancel() {
            this.isRun = false;
        }
    }

    public static final class Build {
        private String ip;
        private String macAddress;
        private UsbDevice usbDevice;
        private int port;
        private CONN_METHOD connMethod;
        private Context context;
        private String serialPortPath;
        private int baudrate;
        private int id;

        public Build setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public Build setMacAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Build setUsbDevice(UsbDevice usbDevice) {
            this.usbDevice = usbDevice;
            return this;
        }

        public Build setPort(int port) {
            this.port = port;
            return this;
        }

        public Build setConnMethod(CONN_METHOD connMethod) {
            this.connMethod = connMethod;
            return this;
        }

        public Build setContext(Context context) {
            this.context = context;
            return this;
        }

        public Build setId(int id) {
            this.id = id;
            return this;
        }

        public Build setSerialPort(String serialPortPath) {
            this.serialPortPath = serialPortPath;
            return this;
        }

        public Build setBaudrate(int baudrate) {
            this.baudrate = baudrate;
            return this;
        }

        public DeviceConnFactoryManager build() {
            return new DeviceConnFactoryManager(this);
        }
    }

    public static enum CONN_METHOD {
        BLUETOOTH("BLUETOOTH"),
        USB("USB"),
        WIFI("WIFI"),
        SERIAL_PORT("SERIAL_PORT");

        private String name;

        private CONN_METHOD(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

